% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated.R
\name{getdata}
\alias{getdata}
\title{Get xcmsset object in one step with optimized methods.}
\usage{
getdata(
  path,
  index = FALSE,
  BPPARAM = BiocParallel::SnowParam(),
  pmethod = "hplcorbitrap",
  minfrac = 0.67,
  ...
)
}
\arguments{
\item{path}{the path to your data}

\item{index}{the index of the files}

\item{BPPARAM}{used for BiocParallel package}

\item{pmethod}{parameters used for different instrumentals such as 'hplcorbitrap', 'uplcorbitrap', 'hplcqtof', 'hplchqtof', 'uplcqtof', 'uplchqtof'. The parameters were from the reference}

\item{minfrac}{minimum fraction of samples necessary in at least one of the sample groups for it to be a valid group, default 0.67}

\item{...}{arguments for xcmsSet function}
}
\value{
a xcmsset object for that path or selected samples
}
\description{
Get xcmsset object in one step with optimized methods.
}
\details{
the parameters are extracted from the papers. If you use name other than the name above, you will use the default setting of XCMS. Also I suggest IPO packages or apLCMS packages to get reasonable data for your own instrumental. If you want to summit the results to a paper, remember to include those parameters.
}
\examples{
\dontrun{
library(faahKO)
cdfpath <- system.file('cdf', package = 'faahKO')
xset <- getdata(cdfpath, pmethod = ' ')
}
}
\references{
Patti, G. J.; Tautenhahn, R.; Siuzdak, G. Nat. Protocols 2012, 7 (3), 508–516.
}
\seealso{
\code{\link{getdata2}}, \code{\link{getmzrt}}
}
