#' enrichR package
#'
#' The enrichR package provides an R interface to all enrichR (https://maayanlab.cloud/Enrichr/) databases.
#'
#' @name enrichR-package
#' @author Wajid Jawaid \email{wajid.jawaid@gmail.com}
#' @keywords internal
"_PACKAGE"


#' 790 gene symbols
#'
#' This is a character vector which consists of randomly selected 790 genes.
#'
#' @name genes790
#' @docType data
#' @usage data(genes790)
#' @format vector
#' @keywords datasets
#' @examples
#' data(genes790)
#' length(genes790)
NULL

#' Example input genes
#'
#' This is a character vector which consists of 375 gene symbols taken from the Enrichr website.
#'
#' @name input
#' @docType data
#' @usage data(input)
#' @format vector
#' @keywords datasets
#' @examples
#' data(input)
#' length(input)
NULL

#' Example background genes
#'
#' This is a character vector which consists of 20,625 gene symbols taken from the Enrichr website.
#'
#' @name background
#' @docType data
#' @usage data(background)
#' @format vector
#' @keywords datasets
#' @examples
#' data(background)
#' length(background)
NULL
