% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{hyperparam_test_genetic_algorithm}
\alias{hyperparam_test_genetic_algorithm}
\title{This function can be used in order to try different set of parameters for the genetic
algorithm in a convenient way. This will run each combination of mutation_rate,
nb_elite and alphas possible nb_test_desired times. For each sets of parameters,
results will be saved in a file named according to the set of parameter. One
can regroup the results of each run in a csv file by using the print_csv function
specifying the names of each file that needs to be treated and the number of 
performed runs on each parameter set}
\usage{
hyperparam_test_genetic_algorithm(
  epochs,
  nb_individuals,
  ATCtree,
  observations,
  nb_test_desired,
  mutation_rate,
  nb_elite,
  alphas,
  path = "./",
  num_thread = 1L
)
}
\arguments{
\item{epochs}{: the number of epochs for the genetic algorithm}

\item{nb_individuals}{: the size of the population in the genetic algorithm}

\item{ATCtree}{: ATC tree with upper bound of the DFS (without the root)}

\item{observations}{: observation of the AE based on the medications of each patients
(a DataFrame containing the medication on the first column and the ADR (boolean) on the second)
on which we want to compute the risk distribution}

\item{nb_test_desired}{: number of genetic algorithm runs on each sets of parameters}

\item{mutation_rate}{: a vector with each mutation_rate to be tested}

\item{nb_elite}{: a vector with each nb_elite to be tested}

\item{alphas}{: a vector with each alphas to be tested}

\item{path}{: the path where the resulting files should be written}

\item{num_thread}{: Number of thread to run in parallel if openMP is available, 1 by default}
}
\value{
No return value, this function should output results of the runs of the 
genetic algorithm in a specific format supported by function print_csv
and p_value_csv_file. The files are outputed in path which is current 
directory by default.
}
\description{
This function can be used in order to try different set of parameters for the genetic
algorithm in a convenient way. This will run each combination of mutation_rate,
nb_elite and alphas possible nb_test_desired times. For each sets of parameters,
results will be saved in a file named according to the set of parameter. One
can regroup the results of each run in a csv file by using the print_csv function
specifying the names of each file that needs to be treated and the number of 
performed runs on each parameter set
}
\examples{
\donttest{
data("ATC_Tree_UpperBound_2024")
data("FAERS_myopathy")

# different parameter to test for
mutation_rate = c(.1,.2,.3)
nb_elite = c(0,1,2)
alphas = c(0.5,1,2)
hyperparam_test_genetic_algorithm(epochs = 2, nb_individuals = 2,
                              ATCtree = ATC_Tree_UpperBound_2024, 
                              observations = FAERS_myopathy,
                              nb_test_desired = 5, mutation_rate = mutation_rate,
                              nb_elite = nb_elite, alphas = alphas)
}
}
