% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{histogramToDitribution}
\alias{histogramToDitribution}
\title{Convert the histogram returned by the DistributionApproximation function, to a real number distribution
(that can be used in a test for example)}
\usage{
histogramToDitribution(vec)
}
\arguments{
\item{vec}{: distribution returned by the DistributionAproximationFunction}
}
\value{
A vector containing sampled risk during the MCMC algorithm
}
\description{
Convert the histogram returned by the DistributionApproximation function, to a real number distribution
(that can be used in a test for example)
}
\examples{
\donttest{
data("ATC_Tree_UpperBound_2024")
data("FAERS_myopathy")

 DistributionApproximationResults = DistributionApproximation(epochs = 10,
            ATCtree = ATC_Tree_UpperBound_2024, observations = FAERS_myopathy)
  histogramToDitribution(DistributionApproximationResults$ScoreDistribution)
}
}
