% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/echoice2.R
\name{vd_est_vdm_ss}
\alias{vd_est_vdm_ss}
\title{Estimate volumetric demand model accounting for set size variation (1st order)}
\usage{
vd_est_vdm_ss(
  vd,
  order = 1,
  R = 1e+05,
  keep = 10,
  cores = NULL,
  control = list(include_data = TRUE)
)
}
\arguments{
\item{vd}{volumetric demand data (long format) with set size variation}

\item{order}{integer, either 1 or 2 (for now), indicating linear or quadratic set-size effect}

\item{R}{draws}

\item{keep}{thinning}

\item{cores}{no of CPU cores to use (default: auto-detect)}

\item{control}{list containing additional settings}
}
\value{
est ec-draw object (List)
}
\description{
This model REQUIRES variation in choice-set size
}
\examples{
data(icecream)
#note that for this example dataset, the model is not identified
#because the data lacks variation in set size
icecream_est <- icecream \%>\% vd_est_vdm_ss(R=10, cores=2)
}
