% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/morph.R
\name{e_morph}
\alias{e_morph}
\title{Morphing}
\usage{
e_morph(e, ..., callback, default = 1L)
}
\arguments{
\item{e, ...}{Graphs (from `e_graph`).}

\item{callback}{JavaScript callback function as a
character string (vector of length 1).
This function has access to the `chart` object, as well
as `opts` an array containing the options of the charts
passed to `e` and `...`.}

\item{default}{Default chart to show.}
}
\description{
__This is experimental__
}
\details{
Morph between graphs.
}
\examples{
mtcars2 <- mtcars |> 
  head() |> 
  tibble::rownames_to_column("model")

e1 <- mtcars2 |> 
  e_charts(model) |> 
  e_bar(
    carb, 
    universalTransition = TRUE,
    animationDurationUpdate = 1000L
  )

e2 <- mtcars2 |> 
  e_charts(model) |> 
  e_pie(
    carb, 
    universalTransition = TRUE,
    animationDurationUpdate = 1000L
  )

cb <- "() => {
  let x = 0;
  setInterval(() => {
    x++
    chart.setOption(opts[x \% 2], true);
  }, 3000);
}"

e_morph(e1, e2, callback = cb)

}
