% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynrModel.R
\name{ExpandRandomAsLVModel}
\alias{ExpandRandomAsLVModel}
\title{Extend a user-specified model to include random varibles}
\usage{
ExpandRandomAsLVModel(dynrModel)
}
\arguments{
\item{dynrModel}{a dynrModel object prepared with recipe functions \code{\link{prep.formulaDynamics}}, \code{\link{prep.measurement}}, \code{\link{prep.noise}}, \code{\link{prep.initial}}, \code{\link{dynr.data}}.}
}
\value{
an object of dynrModel that is the expanede model.
}
\description{
Extend a user-specified model to include random varibles
}
\details{
A \code{dynrModel} is a collection of recipes.  The recipes are constructed with the functions unctions \code{\link{prep.formulaDynamics}}, \code{\link{prep.measurement}}, \code{\link{prep.noise}}, \code{\link{prep.initial}}. Additionally, data must be prepared with \code{\link{dynr.data}} and added to the model.
}
\examples{
# model <- dynr.model(dynamics=dynm, measurement=meas, noise=mdcov,
#  initial=initial, data=data, outfile="osc.cpp")
# extended_model <- ExpandRandomAsLVModel(model)


# For full demo examples, see:
# demo(OscWithRand, package="dynr")
# demo(VDPwithRand, package="dynr")
}

