% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abco.R
\name{t_sampleAR1}
\alias{t_sampleAR1}
\title{Sample the TAR(1) coefficients}
\usage{
t_sampleAR1(h_yc, h_phi, h_phi2, h_sigma_eta_t, h_st, prior_dhs_phi = NULL)
}
\arguments{
\item{h_yc}{the \code{T} vector of centered log-volatilities
(i.e., the log-vols minus the unconditional means \code{dhs_mean})}

\item{h_phi}{the \code{1} vector of previous AR(1) coefficient(s)}

\item{h_phi2}{the \code{1} vector of previous penalty coefficient(s)}

\item{h_sigma_eta_t}{the \code{T} vector of log-vol innovation standard deviations}

\item{h_st}{the \code{T} vector of indicators on whether each time-step exceed the estimated threshold}

\item{prior_dhs_phi}{the parameters of the prior for the log-volatility AR(1) coefficient \code{dhs_phi};
either \code{NULL} for uniform on [-1,1] or a 2-dimensional vector of (shape1, shape2) for a Beta prior
on \code{[(dhs_phi + 1)/2]}}
}
\value{
\code{2} vector of sampled TAR(1) coefficient(s)
}
\description{
Compute one draw of the TAR(1) coefficients in a model with Gaussian innovations
and time-dependent innovation variances. In particular, we use the sampler for the
log-volatility TAR(1) process with the parameter-expanded Polya-Gamma sampler. The sampler also applies
to a multivariate case with independent components.
}
