% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stepwise_selection.R
\name{stepwise_selection}
\alias{stepwise_selection}
\title{Simulate dsem}
\usage{
stepwise_selection(
  model_options,
  model_shared,
  options_initial = c(),
  quiet = FALSE,
  criterion = AIC,
  ...
)
}
\arguments{
\item{model_options}{character-vector containing sem elements
that could be included or dropped depending upon their
parsimony}

\item{model_shared}{character-vector containing sem elements
that must be included regardless of parsimony}

\item{options_initial}{character-vector containing some (possible empty)
subset of \code{model_options}, where stepwise selection begins
with that set of model options included.}

\item{quiet}{whether to avoid displaying progress to terminal}

\item{criterion}{function that computes the information criterion to be
minimized, typically using \code{AIC}.  However, users can instead supply
a function that computes CIC using
\code{\link{test_dsep}} and desired settings, presumably including a \code{set.seed}
if missing data are being imputed}

\item{...}{arguments passed to \code{\link{dsem}},
other than \code{sem} e.g., \code{tsdata}, \code{family}
etc.}
}
\value{
An object (list) that includes:
\describe{
\item{model}{the string with the selected SEM model}
\item{step}{a list, where each list element shows the models fitted during
one step in the stepwise algorithm, from first to last step. Each step
then lists a table, where each table row is a single fitted model,
the first column is the AIC for that model, and the subsequent columns show
whether each variable is included (1) or not (0)}
}
}
\description{
Plot from a fitted \code{dsem} model
}
\details{
This function conducts stepwise (i.e., forwards and backwards) model
selection using marginal AIC, while forcing some model elements to be
included and selecting among others.  See \code{link{dsem}} for further
discussion of model selection.
}
\examples{
# Simulate x -> y -> z
set.seed(101)
x = rnorm(100)
y = 0.5*x + rnorm(100)
z = 1*y + rnorm(100)
tsdata = ts(data.frame(x=x, y=y, z=z))

# define candidates
model_options = c(
  "y -> z, 0, y_to_z",
  "x -> z, 0, x_to_z"
)
# define paths that are required
model_shared = "
  x -> y, 0, x_to_y
"

# Do selection
step = stepwise_selection(
  model_options = model_options,
  model_shared = model_shared,
  tsdata = tsdata,
  quiet = TRUE
)

# Check selected model
cat(step$model)

}
