% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text_fun.R
\name{read_ascii}
\alias{read_ascii}
\title{Parse text (from file or user input) into string(s) of text}
\usage{
read_ascii(file = "", quiet = FALSE)
}
\arguments{
\item{file}{The text file to read (or its path). 
If \code{file = ""} (the default), \code{scan} is used 
to read user input from the Console. 
If a text file is stored in a sub-directory, 
enter its path and name here (without any leading or 
trailing "." or "/"). 
Default: \code{file = ""}.}

\item{quiet}{Boolean: Provide user feedback? 
Default: \code{quiet = FALSE}.}
}
\value{
A character vector, with its elements 
denoting different lines of text.
}
\description{
\code{read_ascii} parses text inputs 
(from a file or from user input in the Console) 
into a character vector.
}
\details{
Different lines of text are represented by different elements 
of the character vector returned. 

The \code{getwd} function is used to determine the current 
working directory. This replaces the \bold{here} package, 
which was previously used to determine an (absolute) file path. 

Note that \code{read_ascii} originally contained  
\code{\link{map_text_coord}}, but has been separated to 
enable independent access to separate functionalities.
}
\examples{
## Create a temporary file "test.txt":
# cat("Hello world!", "This is a test.", 
#     "Can you see this text?", 
#     "Good! Please carry on...", 
#     file = "test.txt", sep = "\n")

## (a) Read text (from file): 
# read_ascii("test.txt")
# read_ascii("test.txt", quiet = TRUE)  # y flipped

# unlink("test.txt")  # clean up (by deleting file).
 
\donttest{
## (b) Read text (from file in subdir):
# read_ascii("data-raw/txt/ascii.txt")  # requires txt file

## (c) Scan user input (from console):
# read_ascii()
}

}
\seealso{
\code{\link{map_text_coord}} for mapping text to a table of character coordinates;  
\code{\link{plot_chars}} for a character plotting function.

Other text objects and functions: 
\code{\link{Umlaut}},
\code{\link{capitalize}()},
\code{\link{caseflip}()},
\code{\link{cclass}},
\code{\link{chars_to_text}()},
\code{\link{collapse_chars}()},
\code{\link{count_chars}()},
\code{\link{count_chars_words}()},
\code{\link{count_words}()},
\code{\link{invert_rules}()},
\code{\link{l33t_rul35}},
\code{\link{map_text_chars}()},
\code{\link{map_text_coord}()},
\code{\link{map_text_regex}()},
\code{\link{metachar}},
\code{\link{text_to_chars}()},
\code{\link{text_to_sentences}()},
\code{\link{text_to_words}()},
\code{\link{transl33t}()},
\code{\link{words_to_text}()}
}
\concept{text objects and functions}
