% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_tte.R
\name{utility_tte}
\alias{utility_tte}
\title{Utility function for time-to-event outcomes.}
\usage{
utility_tte(
  d2,
  HRgo,
  w,
  hr1,
  hr2,
  id1,
  id2,
  alpha,
  beta,
  xi2,
  xi3,
  c2,
  c3,
  c02,
  c03,
  K,
  N,
  S,
  steps1,
  stepm1,
  stepl1,
  b1,
  b2,
  b3,
  gamma,
  fixed
)
}
\arguments{
\item{d2}{total events for phase II; must be even number}

\item{HRgo}{threshold value for the go/no-go decision rule}

\item{w}{weight for mixture prior distribution}

\item{hr1}{first assumed true treatment effect on HR scale for prior distribution}

\item{hr2}{second assumed true treatment effect on HR scale for prior distribution}

\item{id1}{amount of information for \code{hr1} in terms of number of events}

\item{id2}{amount of information for \code{hr2} in terms of number of events}

\item{alpha}{significance level}

\item{beta}{\code{1-beta} power for calculation of sample size for phase III}

\item{xi2}{event rate for phase II}

\item{xi3}{event rate for phase III}

\item{c2}{variable per-patient cost for phase II}

\item{c3}{variable per-patient cost for phase III}

\item{c02}{fixed cost for phase II}

\item{c03}{fixed cost for phase III}

\item{K}{constraint on the costs of the program, default: Inf, e.g. no constraint}

\item{N}{constraint on the total expected sample size of the program, default: Inf, e.g. no constraint}

\item{S}{constraint on the expected probability of a successful program, default: -Inf, e.g. no constraint}

\item{steps1}{lower boundary for effect size category \code{"small"} in RR scale, default: 1}

\item{stepm1}{lower boundary for effect size category \code{"medium"} in RR scale = upper boundary for effect size category "small" in RR scale, default: 0.95}

\item{stepl1}{lower boundary for effect size category \code{"large"} in RR scale = upper boundary for effect size category "medium" in RR scale, default: 0.85}

\item{b1}{expected gain for effect size category \code{"small"}}

\item{b2}{expected gain for effect size category \code{"medium"}}

\item{b3}{expected gain for effect size category \code{"large"}}

\item{gamma}{difference in treatment effect due to different population structures in phase II and III}

\item{fixed}{choose if true treatment effects are fixed or random, if TRUE \code{hr1} is used as fixed effect}
}
\value{
The output of the functions \code{utility_tte()} is the expected utility of the program.
}
\description{
The utility function calculates the expected utility of our drug development program and is given as gains minus costs and depends on the parameters and the expected probability of a successful program.
The utility is in a further step maximized by the \code{optimal_tte()} function.
}
\examples{
res <- utility_tte(d2 = 50, HRgo = 0.8, w = 0.3, 
                                 hr1 =  0.69, hr2 = 0.81, 
                                 id1 = 280, id2 = 420, xi2 = 0.7, xi3 = 0.7,
                                 alpha = 0.025, beta = 0.1,
                                 c2 = 0.75, c3 = 1, c02 = 100, c03 = 150,
                                 K = Inf, N = Inf, S = -Inf,
                                 steps1 = 1, stepm1 = 0.95, stepl1 = 0.85,
                                 b1 = 1000, b2 = 2000, b3 = 3000, 
                                 gamma = 0, fixed = TRUE)
}
\keyword{internal}
