% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dm_get_con.R
\name{dm_get_con}
\alias{dm_get_con}
\title{Get connection}
\usage{
dm_get_con(dm)
}
\arguments{
\item{dm}{A \code{dm} object.}
}
\value{
The \code{\link[DBI:DBIConnection-class]{DBI::DBIConnection}} object for a \code{dm} object.
}
\description{
\code{dm_get_con()} returns the DBI connection for a \code{dm} object.
This works only if the tables are stored on a database, otherwise an error
is thrown.
}
\details{
All lazy tables in a dm object must be stored on the same database server
and accessed through the same connection, because a large part
of the package's functionality relies on efficient joins.
}
\examples{
\dontshow{if (dm:::dm_has_financial()) withAutoprint(\{ # examplesIf}
dm_financial() \%>\%
  dm_get_con()
\dontshow{\}) # examplesIf}
}
