% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interaction.R
\name{ds_interaction}
\alias{ds_interaction}
\alias{interaction}
\title{Compute Interaction Index}
\usage{
ds_interaction(.data, .cols, .name, .comp = FALSE)

interaction(..., .data = dplyr::across(everything()))
}
\arguments{
\item{.data}{\link[tibble:tibble-package]{tibble}}

\item{.cols}{\href{https://tidyselect.r-lib.org/reference/language.html}{\code{tidy-select}}
Columns to compute the measure with. Must be at least 2 columns. If more than 2, treats
first column as first group and sum of other columns as second.}

\item{.name}{name for column with Interaction index. Leave missing to return a vector.}

\item{.comp}{Default is FALSE. FALSE returns the sum, TRUE returns the components.}

\item{...}{arguments to forward to ds_interaction from interaction}
}
\value{
a \link[tibble:tibble-package]{tibble} or numeric vector if .name missing
}
\description{
Compute Interaction Index
}
\examples{
data('de_county')
ds_interaction(de_county, c(pop_white, starts_with('pop_')))
ds_interaction(de_county, starts_with('pop_'), 'interaction')
}
\concept{exposure}
