% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abs_conc.R
\name{ds_abs_conc}
\alias{ds_abs_conc}
\alias{abs_conc}
\title{Compute Absolute Concentration}
\usage{
ds_abs_conc(.data, .cols, .name)

abs_conc(..., .data = dplyr::across(everything()))
}
\arguments{
\item{.data}{\link[tibble:tibble-package]{tibble} with sf geometry}

\item{.cols}{\href{https://tidyselect.r-lib.org/reference/language.html}{\code{tidy-select}}
Columns to compute the measure with. Must be at least 2 columns. If more than 2, treats
first column as first group and sum of other columns as second.}

\item{.name}{name for column with absolute concentration. Leave missing to return a vector.}

\item{...}{arguments to forward to ds_abs_conc from abs_conc}
}
\value{
a \link[tibble:tibble-package]{tibble} or numeric vector if .name missing
}
\description{
Compute Absolute Concentration
}
\examples{
data('de_county')
ds_abs_conc(de_county, c(pop_black, starts_with('pop_')))
ds_abs_conc(de_county, c(pop_black, starts_with('pop_')), 'abs_conc')
}
\concept{concentration}
