% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.distribution}
\alias{plot.distribution}
\title{Plot the p.m.f, p.d.f or c.d.f. of a univariate distribution}
\usage{
\method{plot}{distribution}(
  x,
  cdf = FALSE,
  p = c(0.1, 99.9),
  len = 1000,
  all = FALSE,
  legend_args = list(),
  ...
)
}
\arguments{
\item{x}{an object of class \code{c("name", "distribution")}, where
\code{"name"} is the name of the distribution.}

\item{cdf}{A logical scalar.  If \code{cdf = TRUE} then the cumulative
distribution function (c.d.f.) is plotted.  Otherwise, the probability
density function (p.d.f.), for a continuous variable, or the probability
mass function (p.m.f.), for a discrete variable, is plotted.}

\item{p}{A numeric vector.  If \code{xlim} is not passed in \code{...}
then \code{p} is the fallback option for setting the range of values
over which the p.m.f, p.d.f. or c.d.f is plotted.  See \strong{Details}.}

\item{len}{An integer scalar.  If \code{x} is a continuous distribution
object then \code{len} is the number of values at which the p.d.f or
c.d.f. is evaluated to produce the plot.  The larger \code{len} is the
smoother is the curve.}

\item{all}{A logical scalar.  If \code{all = TRUE} then a separate
distribution is plotted for all the combinations of parameter
values present in the parameter vectors present in \code{x}.  These
combinations are generated using \code{\link{expand.grid}}.  If
\code{all = FALSE} then the number of distributions plotted is equal to
the maximum of the lengths of these parameter vectors, with shorter
vectors recycled to this length if necessary using \code{\link{rep_len}}.}

\item{legend_args}{A list of arguments to be passed to
\code{\link[graphics]{legend}}.  In particular, the argument \code{x}
(perhaps in conjunction with \code{legend_args$y}) can be used to set the
position of the legend.  If \code{legend_args$x} is not supplied then
\code{"bottomright"} is used if \code{cdf = TRUE} and \code{"topright"} if
\code{cdf = FALSE}.}

\item{...}{Further arguments to be passed to \code{\link[graphics]{plot}},
\code{\link[stats:ecdf]{plot.ecdf}} and \code{\link[graphics]{lines}},
such as \code{xlim, ylim, xlab, ylab, main, lwd, lty, col, pch}.}
}
\value{
An object with the same class as \code{x}, in which the parameter
vectors have been expanded to contain a parameter combination for each
function plotted.
}
\description{
Plot method for an object inheriting from class \code{"distribution"}.
By default the probability density function (p.d.f.), for a continuous
variable, or the probability mass function (p.m.f.), for a discrete
variable, is plotted.  The cumulative distribution function (c.d.f.)
will be plotted if \code{cdf = TRUE}.  Multiple functions are included
in the plot if any of the parameter vectors in \code{x} has length greater
than 1.  See the argument \code{all}.
}
\details{
If \code{xlim} is passed in \code{...} then this determines the
range of values of the variable to be plotted on the horizontal axis.
If \code{x} is a discrete distribution object then the values for which
the p.m.f. or c.d.f. is plotted is the smallest set of consecutive
integers that contains both components of \code{xlim}.  Otherwise,
\code{xlim} is used directly.

If \code{xlim} is not passed in \code{...} then the range of values spans
the support of the distribution, with the following proviso: if the
lower (upper) endpoint of the distribution is \code{-Inf} (\code{Inf})
then the lower (upper) limit of the plotting range is set to the
\code{p[1]}\\% (\code{p[2]}\\%) quantile of the distribution.

If the name of \code{x} is a single upper case letter then that name is
used to labels the axes of the plot.  Otherwise, \code{x} and
\code{P(X = x)} or \code{f(x)} are used.

A legend is included only if at least one of the parameter vectors in
\code{x} has length greater than 1.

Plots of c.d.f.s are produced using calls to
\code{\link[stats]{approxfun}} and \code{\link[stats:ecdf]{plot.ecdf}}.
}
\examples{
B <- Binomial(20, 0.7)
plot(B)
plot(B, cdf = TRUE)

B2 <- Binomial(20, c(0.1, 0.5, 0.9))
plot(B2, legend_args = list(x = "top"))
x <- plot(B2, cdf = TRUE)
x$size
x$p

X <- Poisson(2)
plot(X)
plot(X, cdf = TRUE)

G <- Gamma(c(1, 3), 1:2)
plot(G)
plot(G, all = TRUE)
plot(G, cdf = TRUE)

C <- Cauchy()
plot(C, p = c(1, 99), len = 10000)
plot(C, cdf = TRUE, p = c(1, 99))
}
