% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{cost_path_diagonal_cpp}
\alias{cost_path_diagonal_cpp}
\title{(C++) Orthogonal and Diagonal Least Cost Path}
\usage{
cost_path_diagonal_cpp(dist_matrix, cost_matrix)
}
\arguments{
\item{dist_matrix}{(required, numeric matrix). Distance matrix between two
time series.}

\item{cost_matrix}{(required, numeric matrix). Cost matrix generated from
\code{dist_matrix}.}
}
\value{
data frame
}
\description{
Computes the least cost matrix from a distance matrix.
Considers diagonals during computation of least-costs. In case of ties,
diagonals are favored.
}
\examples{
#simulate two time series
x <- zoo_simulate(seed = 1)
y <- zoo_simulate(seed = 2)

#distance matrix
dist_matrix <- distance_matrix_cpp(
  x = x,
  y = y,
  distance = "euclidean"
)

#least cost matrix
cost_matrix <- cost_matrix_orthogonal_cpp(
  dist_matrix = dist_matrix
)

#least cost path
cost_path <- cost_path_diagonal_cpp(
  dist_matrix = dist_matrix,
  cost_matrix = cost_matrix
)

cost_path
}
\seealso{
Other Rcpp_cost_path: 
\code{\link{cost_path_cpp}()},
\code{\link{cost_path_diagonal_bandwidth_cpp}()},
\code{\link{cost_path_orthogonal_bandwidth_cpp}()},
\code{\link{cost_path_orthogonal_cpp}()},
\code{\link{cost_path_slotting_cpp}()},
\code{\link{cost_path_sum_cpp}()},
\code{\link{cost_path_trim_cpp}()}
}
\concept{Rcpp_cost_path}
