% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_regression.R
\name{linreg}
\alias{linreg}
\title{Linear Regression Table with Univariable and Multivariable Analysis}
\usage{
linreg(data, outcome, predictors, report = TRUE)
}
\arguments{
\item{data}{A data frame containing the outcome and predictor variables.}

\item{outcome}{Name of the continuous outcome variable (character).}

\item{predictors}{Character vector of predictor variable names.}

\item{report}{Logical; if TRUE, prints an automatic textual interpretation of multivariable results (default: TRUE).}
}
\value{
If \code{report = FALSE}, returns a \code{flextable} summarizing univariable and multivariable beta coefficients, 95\% CI, and p-values.
If \code{report = TRUE}, returns a list with \code{table} (the flextable) and \code{interpretation} (textual summary of multivariable results).
}
\description{
Fits univariable and multivariable linear regression models for a continuous outcome,
summarizing beta coefficients, 95\% confidence intervals, and p-values.
Factor predictors include reference levels in the table. Returns a formatted \code{flextable}
and optionally provides an automatic textual interpretation of results.
}
\examples{
# Apply linear regression on iris dataset
linreg(
  data = iris,
  outcome = "Sepal.Length",
  predictors = c("Sepal.Width", "Petal.Length", "Species"),
  report = TRUE
)
}
