% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{deeptrafo}
\alias{deeptrafo}
\title{Deep Conditional Transformation Models}
\usage{
deeptrafo(
  formula,
  data,
  response_type = get_response_type(data[[all.vars(fml)[1]]]),
  order = get_order(response_type, data[[all.vars(fml)[1]]]),
  addconst_interaction = 0,
  latent_distr = "logistic",
  loss = "nll",
  loss_args = NULL,
  monitor_metrics = NULL,
  trafo_options = trafo_control(order_bsp = order, response_type = response_type),
  return_data = FALSE,
  engine = "tf",
  ...
)
}
\arguments{
\item{formula}{Formula specifying the response, interaction, shift terms
as \code{response | interacting ~ shifting}.
auto-regressive transformation models (ATMs).}

\item{data}{Named \code{list} or \code{data.frame} which may contain both
structured and unstructured data.}

\item{response_type}{Character; type of response. One of \code{"continuous"},
\code{"survival"}, \code{"count"}, or \code{"ordered"}. If not supplied
manually it is determined by the first entry in \code{data[[response]]}.}

\item{order}{Integer; order of the response basis. Default 10 for Bernstein
basis or number of levels minus one for ordinal responses.}

\item{addconst_interaction}{Positive constant;
a constant added to the additive predictor of the interaction term.
If \code{NULL}, terms are left unchanged. If 0 and predictors have
negative values in their design matrix, the minimum value of all predictors
is added to ensure positivity. If > 0, the minimum value plus the
\code{addconst_interaction} is added to each predictor in the interaction
term. This ensures a monotone non-decreasing transformation function in
the response when using (tensor product) spline bases in the interacting
term.}

\item{latent_distr}{A \code{tfd_distribution} or character; the base distribution for
transformation models. If character, can be \code{"normal"}, \code{"logistic"},
\code{"gumbel"} or \code{"gompertz"}.}

\item{loss}{Character; specifies the loss function used. The default is
\code{"nll"}, an internal function which takes \code{latent_distr} as an
argument and returns a function with arguments \code{y_true} and
\code{y_pred} to be given to the underlying 'keras' model. Custom loss
functions can be supplied with the same structure, either as a character
or function.}

\item{loss_args}{Further additional arguments to \code{loss}.}

\item{monitor_metrics}{See \code{\link[deepregression]{deepregression}}}

\item{trafo_options}{Options for transformation models such as the basis
function used, see \code{\link[deeptrafo]{trafo_control}} for more details.}

\item{return_data}{Include full data in the returned object. Defaults to
\code{FALSE}. Set to \code{TRUE} if inteded to use
\code{\link[stats]{simulate}} afterwards.}

\item{engine}{Ignored; for compatibility with package \code{deepregression}.}

\item{...}{Additional arguments passed to \code{deepregression}}
}
\value{
An object of class \code{c("deeptrafo", "deepregression")}
}
\description{
Deep Conditional Transformation Models
}
\details{
\code{deeptrafo} is the main function for setting up neural network
    transformation models and is called by all aliases for the more special
    cases (see e.g. \code{\link[deeptrafo]{ColrNN}}). The naming convention
    of the aliases follow the 'tram' package (see e.g. \code{\link[tram]{Colr}})
    and add the suffix "NN" to the function name.
}
\examples{
if (.Platform$OS.type != "windows" &&
  reticulate::py_available() &&
  reticulate::py_module_available("tensorflow") &&
  reticulate::py_module_available("keras") &&
  reticulate::py_module_available("tensorflow_probability")) {
  data("wine", package = "ordinal")
  wine$z <- rnorm(nrow(wine))
  wine$x <- rnorm(nrow(wine))

  nn <- \(x) x |>
    layer_dense(input_shape = 1L, units = 2L, activation = "relu") |>
    layer_dense(1L)

  fml <- rating ~ 0 + temp + contact + s(z, df = 3) + nn(x)

  m <- deeptrafo(fml, wine,
    latent_distr = "logistic", monitor_metric = NULL,
    return_data = TRUE, list_of_deep_models = list(nn = nn)
  )

  print(m)

  m \%>\% fit(epochs = 10, batch_size = nrow(wine))
  coef(m, which_param = "interacting")
  coef(m, which_param = "shifting")
  fitted(m)
  predict(m, type = "pdf")
  predict(m, type = "pdf", newdata = wine[, -2])
  logLik(m)
  logLik(m, newdata = wine[1:10, ])
  plot(m)
  mcv <- cv(m, cv_folds = 3)
  ens <- ensemble(m, n_ensemble = 3)
  coef(ens)
}

}
\references{
Kook, L., Baumann, P. F., Dürr, O., Sick, B., & Rügamer, D.
(2024). Estimating conditional distributions with neural networks using R
package deeptrafo. Journal of Statistical Software.
\doi{10.18637/jss.v111.i10}.
}
