% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/usage2.R
\name{usage2}
\alias{usage2}
\title{Retrieve Usage Data from a DeepL API Free Account}
\usage{
usage2(auth_key)
}
\arguments{
\item{auth_key}{Character. Your DeepL API authentication key. If missing, the function uses 
the \code{DEEPL_API_KEY} environment variable. You can set it using 
\code{Sys.setenv(DEEPL_API_KEY = "your_key")} or define it in your \code{.Renviron} file for persistent use.}
}
\value{
A named list or structured object containing:
\itemize{
  \item \code{character_count} – Number of characters used in the current billing period.
  \item \code{character_limit} – Total character limit for the current billing period.
}
}
\description{
\code{usage2} returns the character usage and configured character limit for the current billing period
    of a DeepL API Free account.
}
\details{
To use this function, you must register for a DeepL API Free account at 
\url{https://www.deepl.com/pro#developer}. The Free plan includes up to 500,000 characters per month.
}
\examples{
\dontrun{
usage2()
}

}
\references{
\href{https://developers.deepl.com/docs/api-reference/usage-and-quota}{DeepL API Documentation — Usage}
}
