% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distribute.R
\name{cvap_distribute}
\alias{cvap_distribute}
\title{Estimate CVAP at the Block Level}
\usage{
cvap_distribute(cvap, block, wts = "pop", include_implied = TRUE)
}
\arguments{
\item{cvap}{cvap data at the block group level, using default settings of \code{get_cvap()}}

\item{block}{block data data for the Census before (or the same as) the year of the cvap data}

\item{wts}{\code{'pop'} (default) or \code{'vap'} for the group to distribute by.}

\item{include_implied}{logical if a column for the implied total (\code{impl_cvap}) should be included. Default is \code{TRUE}}
}
\value{
cvap tibble estimated at the block level
}
\description{
Assuming citizenship homogeneity within block group race/ethnicity, estimates
down from block groups to the block level, proportionally by group if possible,
otherwise by total population.
}
\examples{
\dontrun{
# Requires API set up with tidycensus
state <- 'DE'
cvap <- cvap_get(state, year = 2019)
de_block <- censable::build_dec(geography = 'block',
state = state, year = 2010, geometry = FALSE)
}
# Alternatively, using example data
state <- 'DE'
cvap <- cvap_get(state, year = 2019)
data('de_block')
cvap_block <- cvap_distribute(cvap, de_block)

}
\concept{distribute}
