% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TTC_wei.R
\name{TTC_wei}
\alias{TTC_wei}
\title{TTC_wei function}
\usage{
TTC_wei(z_pcured = z_pcured, z_ucured = z_ucured, theta, epsilon = 0.05)
}
\arguments{
\item{z_pcured}{covariates matrix acting on cure proportion}

\item{z_ucured}{covariates matrix acting on survival function of uncured}

\item{theta}{estimated parameters}

\item{epsilon}{value fixed by user to estimate the TTC \eqn{\text{Pi}(t)\geq (1-\epsilon)}.
By default \eqn{\epsilon = 0.05}.}
}
\description{
calculates the probability Pi(t) of being cured at a given time
t after diagnosis knowing that he/she was alive up to time t. In other words,
Pi(t)=(probability of being cured and alive up to time t given xi)/
(probability of being alive up to time t given xi)

Note that this function is for mixture cure model with Weibull distribution
considered for uncured patients.
}
\references{
Boussari O, Bordes L, Romain G, Colonna M, Bossard N, Remontet L,
Jooste V. Modeling excess hazard with time-to-cure as a parameter.
Biometrics. 2021 Dec;77(4):1289-1302. doi: 10.1111/biom.13361.
Epub 2020 Sep 12. PMID: 32869288.
(\href{https://pubmed.ncbi.nlm.nih.gov/32869288/}{pubmed})

Boussari O, Romain G, Remontet L, Bossard N, Mounier M, Bouvier AM,
Binquet C, Colonna M, Jooste V. A new approach to estimate time-to-cure from
cancer registries data. Cancer Epidemiol. 2018 Apr;53:72-80.
doi: 10.1016/j.canep.2018.01.013. Epub 2018 Feb 4. PMID: 29414635.
(\href{https://pubmed.ncbi.nlm.nih.gov/29414635/}{pubmed})

Phillips N, Coldman A, McBride ML. Estimating cancer prevalence using
mixture models for cancer survival. Stat Med. 2002 May 15;21(9):1257-70.
doi: 10.1002/sim.1101. PMID: 12111877.
(\href{https://pubmed.ncbi.nlm.nih.gov/12111877/}{pubmed})

De Angelis R, Capocaccia R, Hakulinen T, Soderman B, Verdecchia A. Mixture
models for cancer survival analysis: application to population-based data
with covariates. Stat Med. 1999 Feb 28;18(4):441-54.
doi: 10.1002/(sici)1097-0258(19990228)18:4<441::aid-sim23>3.0.co;2-m.
PMID: 10070685.
(\href{https://pubmed.ncbi.nlm.nih.gov/10070685/}{pubmed})
}
\author{
Juste Goungounga, Judith Breaud, Olayide Boussari, Laura Botta, Valerie Jooste
}
\keyword{internal}
