% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctKalman.R
\name{ctPredictTIP}
\alias{ctPredictTIP}
\title{ctPredictTIP}
\usage{
ctPredictTIP(
  sf,
  tipreds = "all",
  subject = 1,
  timestep = "auto",
  doDynamics = TRUE,
  plot = TRUE,
  quantiles = c(0.16, 0.5, 0.84),
  discreteTimeQuantiles = c(0.025, 0.5, 0.975),
  showUncertainty = TRUE,
  TIPvalues = NA
)
}
\arguments{
\item{sf}{A fitted ctStanFit object from the ctsem package.}

\item{tipreds}{A character vector specifying which time independent predictors to use. Default is 'all', which uses all time independent predictors in the model.}

\item{subject}{An integer value specifying the internal ctsem subject ID (mapping visible under myfit$setup$idmap) for which predictions are made. 
This is relevant only when time dependent predictors are also included in the model.}

\item{timestep}{A numeric value specifying the time step for predictions. Default is 'auto', which tries to automatically determine an appropriate time step.}

\item{doDynamics}{A logical value indicating whether to plot the effects of time independent predictors on the dynamics of the system. Default is TRUE. 
Can be problematic for systems with many dimensions.}

\item{plot}{A logical value indicating whether to ggplot the results instead of returning a data.frame of predictions. Default is TRUE.}

\item{quantiles}{A numeric vector specifying the quantiles of the time independent predictors to plot. Default is 1SD either side and the median, c(.32,.5,.68).}

\item{discreteTimeQuantiles}{a numeric vector of length 3 specifying the quantiles of the discrete time points to plot, when 
showUncertainty is TRUE.}

\item{showUncertainty}{A logical value indicating whether to plot the uncertainty of the predictions. Default is TRUE.}

\item{TIPvalues}{An nvalue * nTIpred numeric matrix specifying the fixed values for each time independent predictor effect to plot. 
Default is NA, which instead relies on the quantiles specified in the quantiles argument.}
}
\value{
If plot is TRUE, a list of ggplot objects showing the estimated effects of covariate moderators. Otherwise, a data frame with the predictions.
}
\description{
Outputs the estimated effect of time independent predictors (covariate moderators) on the expected observations.
}
\details{
This function estimates the effects of covariate moderators on the expected process 
and observations for a specified subject in a dynamic system. The covariate moderators are defined at the specified quantiles, 
and their effects on the trajectory are plotted or returned as a data frame.
}
\examples{
# Example usage:
ctPredictTIP(ctstantestfit, tipreds='all', doDynamics=FALSE, plot=TRUE)
}
