% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bbdml.R
\name{bbdml}
\alias{bbdml}
\title{Maximum Likelihood for the Beta-binomial Distribution}
\usage{
bbdml(
  formula,
  phi.formula,
  data,
  link = "logit",
  phi.link = "logit",
  method = "trust",
  control = list(maxit = 1000, reltol = 1e-14),
  numerical = FALSE,
  nstart = 1,
  inits = NULL,
  allow_noninteger = FALSE,
  robust = FALSE,
  ...
)
}
\arguments{
\item{formula}{an object of class \code{formula}: a symbolic description of the model to be fitted to the abundance}

\item{phi.formula}{an object of class \code{formula} without the response: a symbolic description of the model to be fitted to the dispersion}

\item{data}{a data frame or \code{phyloseq} object containing the variables in the models}

\item{link}{link function for abundance covariates, defaults to \code{"logit"}}

\item{phi.link}{link function for dispersion covariates, defaults to \code{"logit"}}

\item{method}{optimization method, defaults to \code{"trust"}, or see \code{\link[optimx]{optimr}} for other options}

\item{control}{optimization control parameters (see \code{\link[optimx]{optimr}})}

\item{numerical}{Boolean. Defaults to \code{FALSE}. Indicator of whether to use the numeric Hessian (not recommended).}

\item{nstart}{Integer. Defaults to \code{1}. Number of starts for optimization.}

\item{inits}{Optional initializations as rows of a matrix. Defaults to \code{NULL}.}

\item{allow_noninteger}{Boolean. Defaults to \code{FALSE}. Should noninteger W's and M's be allowed? This behavior was not permitted prior to v4.1, needs to be explicitly allowed.}

\item{robust}{Should robust standard errors be returned? If not, model-based standard arras are used. Logical, defaults to \code{FALSE}.}

\item{...}{Optional additional arguments for \code{\link[optimx]{optimr}} or \code{\link[trust]{trust}}}
}
\value{
An object of class \code{bbdml}.
}
\description{
Maximum Likelihood for the Beta-binomial Distribution
}
\examples{
# data frame example
data(soil_phylum_small_otu1)
bbdml(formula = cbind(W, M - W) ~ DayAmdmt,
phi.formula = ~ DayAmdmt,
data = soil_phylum_small_otu1)

# phyloseq example (only run this if you have phyloseq installed)
\dontrun{
data(soil_phylum_small_sample)
data(soil_phylum_small_otu)
data_phylo <- phyloseq::phyloseq(phyloseq::sample_data(soil_phylum_small_sample),
phyloseq::otu_table(soil_phylum_small_otu, taxa_are_rows = TRUE))
bbdml(formula = Proteobacteria ~ DayAmdmt,
phi.formula = ~ DayAmdmt,
data = data_phylo)
}

}
