% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/copernicus_download.R
\name{copernicus_download}
\alias{copernicus_download}
\title{Download data from Copernicus Marine}
\usage{
copernicus_download(
  dataset_id,
  variables,
  start_date,
  end_date,
  bbox = c(-180, 179.92, -80, 90),
  depth = c(0.494, 0.494),
  dataset_version = "202406",
  output_file = NULL,
  username = NULL,
  password = NULL,
  verbose_download = TRUE,
  ...
)
}
\arguments{
\item{dataset_id}{ID of the dataset (exact).}

\item{variables}{Vector or list of variables to download.}

\item{start_date}{Download start date (YYYY-MM-DD).}

\item{end_date}{Download end date (YYYY-MM-DD).}

\item{bbox}{Vector of 4 values (xmin, xmax, ymin, ymax) for the region.}

\item{depth}{Vector of 2 values: minimum and maximum depth.}

\item{dataset_version}{Dataset version.}

\item{output_file}{Output file path. By default, generates one in tempdir().}

\item{username}{Copernicus Marine username (optional, will try to get from stored credentials).}

\item{password}{Copernicus Marine password (optional, will try to get from stored credentials).}

\item{verbose_download}{Show detailed messages.}

\item{...}{Other extra arguments passed to the Python function.}
}
\value{
Absolute path to the downloaded file, or NULL if it fails.
}
\description{
Downloads .nc files from the Copernicus Marine catalog. Allows specifying all options of the Python function.
Uses stored credentials from options/environment variables if available.
}
