% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PairwiseMatrix.R
\docType{class}
\name{PairwiseMatrix-class}
\alias{PairwiseMatrix-class}
\alias{PairwiseMatrix}
\alias{as.PairwiseMatrix}
\alias{as.PairwiseMatrix,matrix-method}
\alias{as.matrix,PairwiseMatrix-method}
\title{Pairwise Similarity/Distance Matrix}
\usage{
as.PairwiseMatrix(x, ...)

\S4method{as.PairwiseMatrix}{matrix}(x, ...)

\S4method{as.matrix}{PairwiseMatrix}(x, ...)
}
\arguments{
\item{x}{an \R object.}

\item{...}{additional arguments to be passed to methods.}
}
\description{
Represents a pairwise similarity or distance matrix.
}
\details{
If the elements being compared are from the same set, the matrix
may be symmetric if the comparator is symmetric. In this case, entries
in the upper triangle and/or along the diagonal may not be stored in
memory, since they are redundant.
}
\section{Functions}{
\itemize{
\item \code{as.PairwiseMatrix}: Convert an R object \code{x} to a \code{PairwiseMatrix}.

\item \code{as.PairwiseMatrix,matrix-method}: Convert an ordinary \code{\link{matrix}} \code{x} to a \code{PairwiseMatrix}.

\item \code{as.matrix,PairwiseMatrix-method}: Convert a \code{PairwiseMatrix} \code{x} to an ordinary \code{\link{matrix}}.
}}

\section{Slots}{

\describe{
\item{\code{.Data}}{entries of the matrix in column-major order. Entries in the
upper triangle and/or on the diagonal may be omitted.}

\item{\code{Dim}}{integer vector of length 2. The dimensions of the matrix.}

\item{\code{Diag}}{logical indicating whether the diagonal entries are stored in
\code{.Data}.}
}}

