% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ordered_dict.R
\name{ordered_dict}
\alias{ordered_dict}
\title{Ordered Dictionary}
\usage{
ordered_dict(items = NULL, keys = NULL)
}
\arguments{
\item{items}{a list of items}

\item{keys}{a list of keys, use \code{names(items)} if \code{NULL}}
}
\description{
\code{ordered_dict} creates an ordered dictionary.
}
\details{
Following methods are exposed:
\preformatted{
.$set(key, value)
.$get(key, default)
.$remove(key, silent = FALSE)
.$pop(key, default)
.$popitem(last = TRUE)
.$has(key)
.$keys()
.$values()
.$update(d)
.$clear()
.$size()
.$as_list()
.$print()
}
\itemize{
\item \code{key}: scalar character, environment or function
\item \code{value}: any R object, value of the item
\item \code{default}: optional, the default value of an item if the key is not found
\item \code{d}: an ordered_dict object
}
}
\examples{
d <- ordered_dict(list(apple = 5, orange = 10))
d$set("banana", 3)
d$get("apple")
d$as_list()  # the order the item is preserved
d$pop("orange")
d$as_list()  # "orange" is removed
d$set("orange", 3)$set("pear", 7)  # chain methods
}
\seealso{
\link{dict}
}
