\name{pfib_c_score}
\alias{pfib_c_score}
\title{
Pediatric Fibrosis Score (Continuous) (pFIB-c)
}
\description{
Calculates the continuous Pediatric Fibrosis Score (pFIB-c) to predict the probability of advanced liver fibrosis (Stage F3-F4) in children with Metabolic Dysfunction-Associated Steatotic Liver Disease (MASLD). The score is derived from four clinical variables: AST, ALT, Platelet count, and BMI z-score.
}
\usage{
pfib_c_score(ast, alt, platelet_count, bmi_z_score)
}
\arguments{
  \item{ast}{
Numeric. Aspartate Aminotransferase level in U/L.
}
  \item{alt}{
Numeric. Alanine Aminotransferase level in U/L.
}
  \item{platelet_count}{
Numeric. Platelet count in x10^9/L (e.g., 250).
}
  \item{bmi_z_score}{
Numeric. Body Mass Index z-score (standard deviation score based on age and sex).
}
}
\details{
The logit formula used is:
\deqn{Logit = -6.892 + (0.023 \times AST) + (0.028 \times ALT) - (0.010 \times Platelets) + (1.126 \times BMI\_z)}
\deqn{pFIB-c = \frac{1}{1 + e^{-Logit}}}
}
\value{
A list containing:
\item{pFIB_c_Probability}{The calculated probability (0-1) of advanced fibrosis.}
\item{Risk_Category}{Interpretation (Low Risk < 0.1, High Risk >= 0.5).}
}
\references{
Alkhouri N, et al. Development and validation of the Pediatric Fibrosis Score (pFIB) and the Pediatric Fibrosis Score Continuous (pFIB-c) for the prediction of liver fibrosis in children with non-alcoholic fatty liver disease. Hepatology. 2024.
}
\examples{

# Example 1: High Risk
# AST 60, ALT 80, Platelets 150, BMI z-score 2.5
pfib_c_score(60, 80, 150, 2.5)

# Example 2: Low Risk
# AST 25, ALT 30, Platelets 300, BMI z-score 1.0
pfib_c_score(25, 30, 300, 1.0)
}
