\name{peld_score_original}
\alias{peld_score_original}
\title{
PELD Score (Pediatric End-Stage Liver Disease) (Original/Pre-2023)
}
\description{
Calculates the PELD score used to prioritize pediatric candidates (younger than 12 years) for liver transplantation. This score estimates the 3-month risk of waitlist mortality using serum bilirubin, INR, albumin, age, and growth failure. (Note: In July 2023, the OPTN updated to the PELD-Cr score, which includes creatinine).
}
\usage{
peld_score_original(bilirubin, inr, albumin, age_years, growth_failure,
                    bilirubin_units = "mg/dL", albumin_units = "g/dL")
}
\arguments{
  \item{bilirubin}{
Numeric. Total Bilirubin level.
}
  \item{inr}{
Numeric. International Normalized Ratio.
}
  \item{albumin}{
Numeric. Serum Albumin level.
}
  \item{age_years}{
Numeric. Patient age in years.
}
  \item{growth_failure}{
Numeric (0 or 1). Presence of growth failure (height or weight < -2 SD below mean for age/gender). (1 = Yes).
}
  \item{bilirubin_units}{
String. Units for bilirubin. "mg/dL" (default) or "umol/L".
}
  \item{albumin_units}{
String. Units for albumin. "g/dL" (default) or "g/L".
}
}
\details{
The formula is:
\deqn{PELD = 10 \times (0.480 \times \ln(Bilirubin) + 1.857 \times \ln(INR) - 0.687 \times \ln(Albumin) + 0.436 \times (Age < 1) + 0.667 \times (Growth Failure))}
Input adjustments: Bilirubin and INR values < 1.0 are set to 1.0.
}
\value{
A list containing:
\item{PELD_Score}{The calculated PELD score (rounded).}
}
\references{
McDiarmid SV, Anand R, Lindblad AS, et al. Development of a pediatric end-stage liver disease score to predict poor outcome in children awaiting liver transplantation. Transplantation. 2002;74(2):173-181. doi:10.1097/00007890-200207270-00006
}
\examples{

# Example 1: High Risk Infant
# Age 0.5 (<1y), Bili 3.0, INR 1.5, Alb 2.5, Growth Failure Yes
peld_score_original(3.0, 1.5, 2.5, 0.5, 1)

# Example 2: Standard Child
# Age 5, Bili 1.0, INR 1.0, Alb 4.0, Growth Failure No
peld_score_original(1.0, 1.0, 4.0, 5, 0)
}
