\name{cheops_pain_scale}
\alias{cheops_pain_scale}
\title{
Children's Hospital of Eastern Ontario Pain Scale (CHEOPS)
}
\description{
Calculates the CHEOPS score, a behavioral observation scale for assessing postoperative pain in children aged 1-7 years. The scale evaluates six behaviors: Cry, Facial, Child Verbal, Torso, Touch, and Legs. A score of 6 or higher generally indicates the need for analgesic intervention.
}
\usage{
cheops_pain_scale(cry, facial, verbal, torso, touch, legs)
}
\arguments{
  \item{cry}{
Numeric.
1: No cry.
2: Moaning or Crying.
3: Scream.
}
  \item{facial}{
Numeric.
0: Smiling.
1: Composed/Neutral.
2: Grimace.
}
  \item{verbal}{
Numeric.
0: Positive statements.
1: None or Complaints other than pain.
2: Pain complaints or Both pain/non-pain complaints.
}
  \item{torso}{
Numeric.
1: Neutral.
2: Shifting, tense, shivering, upright, or restrained.
}
  \item{touch}{
Numeric.
1: Not touching.
2: Reaching, touching, grabbing, or restrained.
}
  \item{legs}{
Numeric.
1: Neutral.
2: Squirming, kicking, drawn up, tensed, standing, or restrained.
}
}
\value{
A list containing:
\item{CHEOPS_Score}{The calculated total score (Range 4-13).}
\item{Interpretation}{Clinical guidance based on the threshold of 6.}
}
\references{
McGrath PJ, Johnson G, Goodman JT, et al. CHEOPS: a behavioral scale for rating postoperative pain in children. Advances in Pain Research and Therapy. 1985;9:395-402.
}
\examples{

# Example 1: Significant Pain
# Crying (2), Grimace (2), Pain complaints (2), Tense torso (2), Touching wound (2), Kicking (2)
# Score = 12
cheops_pain_scale(2, 2, 2, 2, 2, 2)

# Example 2: Comfortable Child
# No cry (1), Composed (1), No verbal (1), Neutral torso (1), Not touching (1), Neutral legs (1)
# Score = 6 (Threshold)
cheops_pain_scale(1, 1, 1, 1, 1, 1)

# Example 3: Very Comfortable
# No cry (1), Smiling (0), Positive verbal (0), Neutral torso (1), Not touching (1),
#Neutral legs (1)
# Score = 4
cheops_pain_scale(1, 0, 0, 1, 1, 1)
}
