% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cell-geom.R
\name{ccLines}
\alias{ccLines}
\title{Draw lines in a region}
\usage{
ccLines(
  x = NULL,
  y = NULL,
  col = ifelse(area, "grey", par("col")),
  lwd = par("lwd"),
  lty = par("lty"),
  type = "l",
  straight = FALSE,
  area = FALSE,
  area.baseline = NULL,
  border = "black",
  baseline = "bottom",
  pt.col = par("col"),
  cex = par("cex"),
  pch = par("pch")
)
}
\arguments{
\item{x}{Data points on x-axis, measured in "current" data coordinate.}

\item{y}{Data points on y-axis, measured in "current" data coordinate.}

\item{col}{Line color.}

\item{lwd}{Line width.}

\item{lty}{Line style.}

\item{type}{Line type, similar as \code{type} argument in \code{\link[graphics]{lines}}, but only in \code{c("l", "o", "h", "s")}}

\item{straight}{Whether draw straight lines between points.}

\item{area}{Whether to fill the area below the lines. If it is set to \code{TRUE}, \code{col} controls the filled color in the area and \code{border} controls color of the line.}

\item{area.baseline}{deprecated, use \code{baseline} instead.}

\item{border}{color for border of the area.}

\item{baseline}{The base line to draw areas. By default it is the minimal of y-range (bottom). It can be a string or a number. If a string, it should be one of \code{bottom} and \code{top}. This argument also works if \code{type} is set to \code{h}.}

\item{pt.col}{If \code{type} is "o", point color.}

\item{cex}{If \code{type} is "o", point size.}

\item{pch}{If \code{type} is "o", point type.}
}
\value{
Object \linkS4class{ccCellGeom}
}
\description{
Object \linkS4class{ccCellGeom} will call the function \link[circlize:circos.lines]{circlize::circos.lines} while drawing.
}
\examples{
library(circlizePlus)
sectors <- letters[1:9]
par <- ccPar(points.overflow.warning = FALSE)
cc <- ccPlot(sectors = sectors, xlim = c(0, 10))
cc <- cc + par
track <- ccTrack(sectors = sectors, ylim = c(0, 10), track.height = 0.5)
cells <- ccCell(sector.index = "a") + ccLines(sort(x = runif(10) * 10), y = runif(10) * 10)
track <- track + cells
cc + track
}
