% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/county.R
\name{county_choropleth}
\alias{county_choropleth}
\title{Create a choropleth map using U.S. county level data:}
\usage{
county_choropleth(
  df,
  map_year = 2024,
  geoid.name = "region",
  geoid.type = "auto",
  value.name = "value",
  num_colors = 7,
  color.max = NULL,
  color.min = NULL,
  na.color = "grey",
  custom.colors = NULL,
  nbreaks = 5,
  county_zoom = NULL,
  state_zoom = NULL,
  projection = "albers",
  border_color = "grey15",
  border_thickness = 0.2,
  background_color = "white",
  gridlines = FALSE,
  latlon_ticks = FALSE,
  whitespace = TRUE,
  label = NULL,
  label_text_size = 2.25,
  label_text_color = "black",
  label_box_color = "white",
  ggrepel_options = NULL,
  legend = NULL,
  legend_position = "right",
  title = NULL,
  return = "plot",
  add_state_outline = TRUE
)
}
\arguments{
\item{df}{A dataframe containing U.S. county level data}

\item{map_year}{Either 2015 or 2024; uses county definitions from that particular year.}

\item{geoid.name}{The name of the variable that identifies each county}

\item{geoid.type}{Either "fips.numeric" or "fips.character"; if "auto", the
function will try to automatically determine geoid.type. See
choroplethr::county.regions.2015 or choroplethr::county.regions.2024 a lookup table.}

\item{value.name}{The name of the variable you wish to plot.}

\item{num_colors}{The number of colors you want in your graph when plotting
continuous data. If num_colors > 1, the variable in question will be
divided into quantiles and converted into a factor with that many levels.
If num_colors = 1, a continuous color gradient will be used; if num_colors = 0,
a diverging color gradient will be used (useful for visualizing negative
and positive numbers).  Use color.max and color.min to control the range of
colors displayed. num_colors is ignored when plotting categorical data.}

\item{color.max}{The color of the highest value in your data. Ignored if the
plotted variable is categorical.}

\item{color.min}{The color of the lowest value in your data. Ignored if the
plotted variable is categorical.}

\item{na.color}{The color you want to assign for regions with missing data}

\item{custom.colors}{A vector of valid R color terms of the to use for the
map when plotting factor variables. The length of this vector must match
the number of levels in your factor variable, or num_colors for a
continuous variable that will be discretized by the function, and the order
should match the order of the levels of in your factor variable.}

\item{nbreaks}{The number of breaks you wish to show in the legend when using
a continuous color scale. Ignored if num_colors > 1.}

\item{county_zoom}{An optional vector of counties to zoom in on, written in
the same manner as geoid.name.}

\item{state_zoom}{An optional vector of states to zoom in on. Elements of
this vector must match one of the columns in choroplethr::state.regions.}

\item{projection}{One of the following: "cartesian", "mercator", "robinson",
or "albers", for equirectangular, Mercator, Robinson, and Albers Equal Area
projections, respectively. When using the Mercator projection for world
maps, setting limits_lon is recommended to prevent exaggeration of the size
of Antarctica.}

\item{border_color}{The color of the borders on your map}

\item{border_thickness}{The thickness of the borders on your map}

\item{background_color}{The background color of your map}

\item{gridlines}{Should gridlines appear on your map?}

\item{latlon_ticks}{Should lat/lon tick marks appear on the edge of your map?}

\item{whitespace}{Add some blank space to the sides of your map? For some
projections, this must be set to FALSE in order for lat/lon ticks and
display correctly.}

\item{label}{The name of variable you wish to use to label your map; must be
one of the variables that appears in the spatial dataframe just prior
plotting (use return = 'sf' to see this dataframe), and in general, can be
any of the allowed geoid.type. This function uses ggplot2::geom_label_repel
to create the labels and ensure that they do not overlap.}

\item{label_text_size}{The size of the text that will appear in each label}

\item{label_text_color}{The color of the text that will appear in each label}

\item{label_box_color}{The color of the box around each label}

\item{ggrepel_options}{A list containing additional arguments to be passed to
geom_label_repel (see ?ggplot2::geom_label_repel)}

\item{legend}{A title for your legend; if NULL, value.name will be used.}

\item{legend_position}{The position of your legend relative to the rest of
the map; can be "top", "bottom", "left", or "right".}

\item{title}{A title for your plot; if NULL, no title will be added.}

\item{return}{If "plot", the function will return the requested map as a
ggplot object. If "sf", the function will return the spatial dataframe used
to draw the map (useful if you wish to customize the map yourself).}

\item{add_state_outline}{Should state borders be outlined in your map?}
}
\description{
Counties must be identified by FIPS code; see choroplethr::county.regions.2015 or 
choroplethr::county.regions.2024 for an object
that can help you coerce your county names into this format.
}
\examples{
\donttest{
# Create a map based on US county data:
data("df_county_demographics")
county_choropleth(df_county_demographics, geoid.name = 'region', geoid.type = 'fips.numeric',
                  value.name = 'median_hh_income',
                  title = "Median Household Income of U.S. Counties", 
                  legend = 'Median HH Income')

county_choropleth(df_county_demographics, geoid.name = 'region', geoid.type = 'fips.numeric',
                  value.name = 'median_hh_income',
                  state_zoom = c('CA', 'OR', 'WA'),
                  title = "Median Household Income of West Coast Counties", 
                  legend = 'Median HH Income')
}
}
