% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecca.r
\name{ecca.cv}
\alias{ecca.cv}
\title{Sparse Canonical Correlation via Reduced-Rank Regression when both X and Y are high-dimensional, with Cross-Validation}
\usage{
ecca.cv(
  X,
  Y,
  lambdas = 0,
  groups = NULL,
  r = 2,
  standardize = FALSE,
  rho = 1,
  B0 = NULL,
  nfold = 5,
  select = "lambda.min",
  eps = 1e-04,
  maxiter = 500,
  verbose = FALSE,
  parallel = FALSE,
  nb_cores = NULL,
  set_seed_cv = NULL,
  scoring_method = "mse",
  cv_use_median = FALSE
)
}
\arguments{
\item{X}{Predictor matrix (n x p)}

\item{Y}{Response matrix (n x q)}

\item{lambdas}{Choice of regularization parameter}

\item{groups}{List of index vectors defining groups of predictors}

\item{r}{Target rank}

\item{standardize}{Whether to scale variables}

\item{rho}{ADMM parameter}

\item{B0}{Initial value for the coefficient matrix (optional)}

\item{nfold}{Number of cross-validation folds}

\item{select}{Which lambda to select: "lambda.min" or "lambda.1se"}

\item{eps}{Convergence threshold for ADMM}

\item{maxiter}{Maximum number of ADMM iterations}

\item{verbose}{Print diagnostics}

\item{parallel}{Whether to run cross-validation in parallel}

\item{nb_cores}{Number of cores to use for parallel processing (default is NULL, which uses all available cores)}

\item{set_seed_cv}{Optional seed for reproducibility of cross-validation folds (de)}

\item{scoring_method}{Method to score the model during cross-validation, either "mse" (mean squared error) or "trace" (trace of the product of matrices)}

\item{cv_use_median}{Whether to use the median of the cross-validation scores instead of the mean. Default is FALSE.}
}
\value{
A list with elements:
\describe{
\item{U}{Canonical direction matrix for X (p x r)}
\item{V}{Canonical direction matrix for Y (q x r)}
\item{cor}{Canonical covariances}
\item{loss}{The prediction error 1/n * \| XU - YV\|^2}
}
}
\description{
Performs group-sparse reduced-rank regression for CCA using either ADMM or CVXR solvers.
}
