% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moc_grid_plot.R
\name{plot_moc_grid}
\alias{plot_moc_grid}
\title{Create a Grid Plot of MOC Results}
\usage{
plot_moc_grid(
  results,
  dataset_names = NULL,
  methods = c("kmeans", "hierarchical", "spectral", "fastgreedy", "metis", "hmetis"),
  plot_file = NULL,
  format = "pdf",
  mar = c(2, 2, 2, 1),
  cex = 0.7,
  point_size = 0.8,
  family = "serif",
  label_style = TRUE,
  maintain_aspect_ratio = TRUE
)
}
\arguments{
\item{results}{Results from analyze_moc_datasets}

\item{dataset_names}{Names of datasets to plot (default: all datasets in results)}

\item{methods}{Methods to plot (default: all available methods)}

\item{plot_file}{Output file for plots (default: NULL)}

\item{format}{Output format, either "pdf" or "eps" (default: "pdf")}

\item{mar}{Margins for plots (default: c(2, 2, 2, 1))}

\item{cex}{Text size multiplier (default: 0.7)}

\item{point_size}{Point size for scatter plots (default: 0.8)}

\item{family}{Font family (default: "serif" for Times New Roman)}

\item{label_style}{Whether to add row/column labels (default: TRUE)}

\item{maintain_aspect_ratio}{Whether to maintain aspect ratio in PDF (default: TRUE)}
}
\value{
Invisibly returns the layout information
}
\description{
Creates a grid plot with datasets as rows and clustering methods as columns.
This function is designed to visualize multiple datasets and methods in a single plot.
}
