% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tboot_dist.R
\name{tboot_dist}
\alias{tboot_dist}
\title{Computation of the Bootstrap-t Distribution}
\usage{
tboot_dist(
  boot_obj,
  comp = 1,
  PLT = TRUE,
  nn = TRUE,
  recenter = FALSE,
  return_values = FALSE,
  ...
)
}
\arguments{
\item{boot_obj}{A \code{boodd} object containing the bootstrap values of eventually a
multivariate statistic
of size \eqn{p}
(first \eqn{p} columns)
and its variance (last \eqn{p} columns).}

\item{comp}{The index of the component of the statistic to be plotted.}

\item{PLT}{Logical. If \code{TRUE} (default), then the function plots the bootstrap-t
distribution, otherwise it only returns the computed distribution.}

\item{nn}{Logical. If \code{TRUE} (default), then a normal approximation is superimposed
on the histogram.}

\item{recenter}{Logical. If \code{TRUE}, then the data is recentered by the bootstrap
mean of the statistic. By default it is \code{FALSE}.}

\item{return_values}{Logical. If \code{TRUE}, the function returns the values
obtained using \code{tboot_dist}. By default it is \code{FALSE}.}

\item{...}{Additional arguments affecting the plot produced (e.g., nclass, main, ylim,...).}
}
\value{
Optionally returns a numeric vector representing the bootstrap-t distribution of
the selected component.
}
\description{
Computes and plots the bootstrap-t distribution of a statistic when an estimator of
the variance is available.
}
\details{
The \code{tboot_dist} function is designed to work with bootstrap samples that
include estimates of both the parameters of interest and their variances.
The function calculates a studentized version of the bootstrap distribution
(the bootstrap-t distribution) and optionally plots this distribution and the normal
approximation.
}
\examples{
set.seed(5)
m=0
n=100
X=rnorm(n,mean=m)
mv=function(X){
  c(mean(X), var(X)/length(X))}
# the function mv computes the estimates of the mean and variance of the mean
resb=boots(X,mv,B=999)
# compare distributions
tboot_dist(resb,1)

}
\references{
Bertail, P. and Dudek, A. (2025). \emph{Bootstrap for
Dependent Data, with an R package} (by Bernard Desgraupes and Karolina Marek) - submitted.

Efron, B., Tibshirani, R. (1993). \emph{An Introduction to the
Bootstrap}, Chapman and Hall.
}
\seealso{
\code{\link{boots}}, \code{\link{class.boodd}}, \code{\link{jackVar}},
\code{\link{confint.boodd}}.
}
\keyword{"Bootstrap-t"}
\keyword{Studentization}
