% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sieveboot.R
\name{sieveboot}
\alias{sieveboot}
\title{Autoregressive Sieve Bootstrap}
\usage{
sieveboot(x, func, B, order = NULL, ...)
}
\arguments{
\item{x}{A vector or time series.}

\item{func}{The function applied to each bootstrap sample.}

\item{B}{A  positive integer; the number of bootstrap replications.}

\item{order}{A positive integer; represents the order of the sieve autoregressive process.
If not provided, it is automatically determined (see details below).}

\item{...}{Optional additional arguments for the \code{func} function.}
}
\value{
Returns an object of class \code{boodd}.
}
\description{
Applies autoregressive sieve bootstrap to stationary time series.
}
\details{
The sieve bootstrap estimates an AR(\eqn{p})
model, with a large \code{order} equal to \eqn{p}, resamples
the centered estimated residuals, and reconstructs an AR(\eqn{p})
bootstrap time series to compute a given statistic.
The default \code{order}, if not specified, is set to
\eqn{4*(n^{1/4})/\log(n)^{1/2}},
where \eqn{n} is the sample size.
}
\examples{
n <- 200
B <- 599
x <- arima.sim(list(order=c(0,0,4),ma=c(0.7,0.4,-0.3,-0.1)),n=n)
b1 <- sieveboot(x,mean,B,order=10)
plot(b1)
}
\references{
Bertail, P. and Dudek, A. (2025). \emph{Bootstrap for
Dependent Data, with an R package} (by Bernard Desgraupes and Karolina Marek) - submitted.

Bühlmann, P. (1997). Sieve Bootstrap for time series.
\emph{Bernoulli,} \bold{3}, 123-148.

Choi, E., Hall, P. (2000). Bootstrap confidence regions computed from autoregressions
of arbitrary order. \emph{Journal of the Royal Statistical Society},
Series B, \bold{62}, 461-477.
}
\seealso{
\code{\link{aidedboot}}.
}
\keyword{"Autoregressive}
\keyword{"Sieve}
\keyword{"Time}
\keyword{bootstrap"}
\keyword{process"}
\keyword{series"}
