% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jackVarBlock.R
\name{jackVarBlock}
\alias{jackVarBlock}
\title{Jackknife Variance Estimator Based on Fixed Length Blocks}
\usage{
jackVarBlock(x, func, length.block, ...)
}
\arguments{
\item{x}{A vector or a matrix representing the data.}

\item{func}{The function used to compute the statistic on each sample.}

\item{length.block}{An integer; the block length.}

\item{...}{Optional additional arguments for the \code{func} function.}
}
\value{
Returns a scalar or a covariance matrix, depending on whether the function \code{func}
is univariate or multivariate. For a function returning a vector of length
\emph{p}, the output will be a covariance matrix of size \emph{p x p}.
}
\description{
Estimates the variance of a statistic applied to a vector or a matrix
using a block jackknife procedure.
}
\details{
The \code{jackVarBlock} function extends the jackknife variance estimation to block data.
The data \code{x} is divided into non-overlapping blocks of length \code{length.block}.
The function \code{func}, having output size equal to \emph{p},
is applied to the data with each block removed in turn to finally compute an empirical
variance of the obtained values. This approach is particularly useful
for dependent data, where traditional jackknife methods may not be appropriate.
}
\examples{
set.seed(1)
x <- arima.sim(list(order = c(1, 0, 4), ar = 0.5, ma = c(0.7, 0.4, -0.3, -0.1)), n = 101)
# Jackknife variance estimator of 'func' with blocks of length length.block
length.block <- 10
V1 <- jackVarBlock(x, mean, length.block)
}
\references{
Bertail, P. and Dudek, A. (2025). \emph{Bootstrap for
Dependent Data, with an R package} (by Bernard Desgraupes and Karolina Marek) - submitted.

Carlstein, E. (1986). The use of subseries methods for estimating the variance
of a general statistic from a stationary time series. \emph{Annals of Statist.},
\bold{14}, 1171-1179.

Gray, H., Schucany, W. and Watkins, T. (1972).
\emph{The Generalized Jackknife Statistics}.
Marcel Dekker, New York.

Quenouille, M.H. (1949). Approximate tests of correlation in time-series.
\emph{J. Roy. Statist. Soc., Ser. B}, \bold{11}, 68-84.
}
\seealso{
\code{\link{jackVar}},
\code{\link{jackFunc}},
\code{\link{blockboot}},
\code{\link{jackFuncBlock}},
\code{\link{jackFuncRegen}}.
}
\keyword{"Statistical}
\keyword{Blocks}
\keyword{Jackknife}
\keyword{Resampling}
\keyword{analysis"}
