% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fieldboot.R
\name{fieldboot}
\alias{fieldboot}
\title{Block Bootstrap of Random Field}
\usage{
fieldboot(
  arr,
  func,
  B,
  length.block,
  ...,
  method = c("movingblock", "nonoverlapping", "circular")
)
}
\arguments{
\item{arr}{A multidimensional real-valued array; it represents a random field on a grid of dimension
equals to dimension of the \code{arr}.}

\item{func}{The function applied to each bootstrap sample.}

\item{B}{A positive integer; the number of bootstrap samples.}

\item{length.block}{A positive integer or vector of integers; it specified the block lengths for blocks.
If a scalar is provided, the same block length is used for all dimensions.}

\item{...}{Optional additional arguments for the \code{func} function.}

\item{method}{The method for array reconstruction:
\itemize{
\item \code{"movingblock"} - Moving Block Bootstrap,
\item \code{"nonoverlapping"} - Nonoverlapping Block Bootstrap,
\item \code{"circular"} - Circular Block Bootstrap (obtained by wrapping the field on the torus).
Default is \code{"movingblock"}.
}}
}
\value{
Returns an object of class \code{boodd}.
}
\description{
Performs a bootstrap analysis of multidimensional array representing a random
field on a lattice, using various block bootstrap methods such as moving block, circular block, or
nonoverlapping block bootstrap.
}
\details{
The \code{fieldboot} function resamples hyper-rectangles constructed using either
moving blocks, nonoverlapping blocks or circular blocks to construct a bootstrap field of the same
dimension as the original one. Then it
applies the specified \code{func} to bootstrap samples of the
provided data array. The \code{length.block} parameter determines the size of the blocks
used in the bootstrap method. The \code{method} parameter specifies the type of block
bootstrap to use. This function is useful for assessing the variability and distribution
properties of a statistic in the context of random fields.
}
\examples{
\donttest{
set.seed(123)
arr <- array(rnorm(1000), dim = c(10, 10, 10))
res <- fieldboot(arr, mean, B = 100, length.block = c(2, 2, 2))
plot(res)
}
}
\references{
Bertail, P. and Dudek, A. (2025). \emph{Bootstrap for
Dependent Data, with an R package} (by Bernard Desgraupes and Karolina Marek) - submitted.

Bertail, P.  Politis, D. N. Rhomari, N. (2000). Subsampling continuous
parameter random fields and a Bernstein inequality,  \emph{Statistics},
\bold{33}, 367-392.

Nordman, D.J.  Lahiri, S.N.(2004). On optimal spatial subsample size for
variance estimation, \emph{The Annals of Statistics}, \bold{32}, 1981-2027.

Politis,  D.N. Romano, J.P. (1993). Nonparametric Resampling for Homogeneous
Strong Mixing Random Fields, \emph{J. Multivar. Anal.}, \bold{47}, 301-328.
}
\seealso{
\code{\link{blockboot}},
\code{\link{jackVarField}},
\code{\link{field.sub}}, \code{\link{fieldbootP}}.
}
\keyword{"Bootstrap"}
\keyword{"Random}
\keyword{fields"}
