% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppw.R
\name{bopt_circy}
\alias{bopt_circy}
\title{Optimal Bootstrap Block Length for Periodically Correlated Time Series.}
\usage{
bopt_circy(
  x,
  period,
  PLT = FALSE,
  parameter = c("mean", "seasonal mean"),
  method = c("EMBB", "CEMBB", "GSBB", "CGSBB"),
  plot_range = NULL
)
}
\arguments{
\item{x}{A numeric vector representing a periodically correlated time series.}

\item{period}{An integer; period length of \code{x}.}

\item{PLT}{Logical. If \code{TRUE} the function plots the Mean Square Error (MSE)
of the bootstrap variance estimator for various block lengths. By default
it is equal to \code{FALSE}.}

\item{parameter}{The possible bopt_circy parameters are:
\itemize{
\item \code{"mean"},
\item \code{"seasonal mean"}.
}}

\item{method}{A choice of the block bootstrap method:
\itemize{
\item \code{"GSBB"} - Generalized Seasonal Block Bootstrap,
\item \code{"CGSBB"} - Circular version of GSBB,
\item \code{"EMBB"} - Extension of Moving Block Bootstrap,
\item \code{"CEMBB"} - Circular version of EMBB.
}}

\item{plot_range}{If \code{PLT=TRUE}, a parameter changing the range of the x-axis in the
plot of MSE. By default \code{plot_range = 10}.}
}
\value{
Returns the optimal block length (integer) for the chosen block bootstrap method.
}
\description{
Calculates the optimal block length for Generalized Seasonal
Block Bootstrap (GSBB), Extension of Moving Block Bootstrap (EMBB),
and their circular versions CGSBB and CEMBB for periodically
correlated time series, in the problems of the overall mean
and seasonal means estimation.
}
\details{
For each bootstrap method implemented here,
the function \code{bopt_circy} computes the optimal block length
for periodically correlated (PC) time series.
The optimal block length is obtained by minimization of the
MSE of the bootstrap variance estimator (see Bertail and Dudek (2024)).
For the \code{GSBB} and \code{CGSBB} the optimal block length has the form
\eqn{k\cdot d \pm 1}, where \eqn{d} is a period length and \eqn{k} is a positive
integer. For the \code{EMBB} and \code{CEMBB} the optimal block length can be of any length.
}
\examples{
# Generate a periodically correlated time series
n=200
b <- arima.sim(n = n, model = list(ar = c(0.5, 0.4), na = 0.5))
period <- 12 
x <- 5*cos(2 * pi /period * (1:n))+5*b * cos(2 * pi /period * (1:n))
# Calculate the optimal block length for GSBB
optimal_choice <- bopt_circy(x, period, parameter= "mean", method= "GSBB")
print(optimal_choice)
}
\references{
Bertail, P. and Dudek, A. (2025). \emph{Bootstrap for
Dependent Data, with an R package} (by Bernard Desgraupes and Karolina Marek) - submitted.

Bertail, P. and Dudek, A.E. (2024). Optimal choice of bootstrap block length
for periodically correlated time series, \emph{ Bernoulli}, \bold{30}, 2521-2545.
}
\seealso{
\code{\link{blockboot.seasonal}}, \code{\link{embb.sample}}.
}
\keyword{"Bootstrap"}
\keyword{"MSE"}
\keyword{"Optimal}
\keyword{"Periodically}
\keyword{block}
\keyword{correlated"}
\keyword{length"}
