% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/06_pvExcessCoupon.R
\name{pvExcessCoupon}
\alias{pvExcessCoupon}
\title{Calculates the Present Value of the Excess Coupon Payment resulting due to higher Coupon Rate as compared the Market Discount Rate.}
\usage{
pvExcessCoupon(couponExcess, times, r)
}
\arguments{
\item{couponExcess}{A vector.}

\item{times}{A vector.}

\item{r}{A number.}
}
\value{
Input values to three arguments  \code{couponExcess} , \code{times} and \code{r}.
}
\description{
Calculates the Present Value of the Excess Coupon Payment resulting due to higher Coupon Rate as compared the Market Discount Rate.
}
\details{
For Example, a Bond is trading at a premium because the coupon rate per period (6 percent) is greater than the market discount rate per period (4 percent). The excess per period is the coupon rate minus market discount rate, times the par value: (0.06 – 0.04) × 100 = +2. The present value of excess is +7.260, discounted using the required yield per period (Adams & Smith, 2019).
Based on this, the method  \code{pvExcessCoupon()} is developed to compute the present value of excess Coupon Payments. So,  \code{pvExcessCoupon()} gives the present value of excess Coupon Payments for values passed to its three arguments. Here, \code{couponExcess} represent the dollar value of excess coupon payment, \code{times} is a vector of number of years ranging from 1 to any specified number of years till maturity, and \code{r} is Market Discount Rate or Required Rate of return. The output is rounded off to three decimal places. The given examples show various ways in which the arguments can be passed to \code{pvExcessCoupon()}.
}
\examples{
pvExcessCoupon(couponExcess=c(2,2,2,2), times=c(1,2,3,4), r= 0.04)
pvExcessCoupon(couponExcess=c(2,2,2,2), times=c(1:4), r= 0.04)
pvExcessCoupon(couponExcess=c(rep(2,4)), times=c(1:4), r= 0.04)
pvExcessCoupon(c(rep(2,4)), c(1:4), 0.04)
}
\references{
Adams,J.F. & Smith,D.J.(2019). Introduction to fixed-income valuation. In CFA Program Curriculum 2020 Level I Volumes 1-6. (Vol. 5, pp. 107-151). Wiley Professional Development (P&T). ISBN 9781119593577, \url{https://bookshelf.vitalsource.com/books/9781119593577}
}
\author{
MaheshP Kumar, \email{maheshparamjitkumar@gmail.com}
}
