% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/25_computingPeriodicDiscRateFRN.R
\name{periodicDiscRateFRN}
\alias{periodicDiscRateFRN}
\title{Calculates periodic discount rate of a Floating-Rate Note (FRN).}
\usage{
periodicDiscRateFRN(estRtrn, mvFRN, priceFRN, maturityYears, periodicity)
}
\arguments{
\item{estRtrn}{A number.}

\item{mvFRN}{A number.}

\item{priceFRN}{A number.}

\item{maturityYears}{A number.}

\item{periodicity}{A number.}
}
\value{
Input values to five arguments  \code{estRtrn} ,\code{mvFRN}, \code{priceFRN}, \code{maturityYears}, and  \code{periodicity}.
}
\description{
Calculates periodic discount rate of a Floating-Rate Note (FRN).
}
\details{
The method \code{periodicDiscRateFRN} is developed to compute periodic discount rate of a Floating-Rate Note (FRN) for the values passed to its five arguments. Here, \code{estRtrn} is a vector of estimated returns on FRN (this does not include repayment of the principal), \code{mvFRN} represents Maturity Value, \code{priceFRN} price of FRN, \code{maturityYears} is number of years to Maturity, and \code{periodicity} is periodicity of interest payments. The given examples show various ways in which the arguments can be passed to \code{periodicDiscRateFRN()}.
}
\examples{
periodicDiscRateFRN(estRtrn=0.8125,mvFRN=100,priceFRN=98,maturityYears=4,periodicity=4)
periodicDiscRateFRN(0.8125, 100, 98, 4, 4)
}
\references{
Adams,J.F. & Smith,D.J.(2019). Introduction to fixed-income valuation. In CFA Program Curriculum 2020 Level I Volumes 1-6. (Vol. 5, pp. 107-151). Wiley Professional Development (P&T). ISBN 9781119593577, \url{https://bookshelf.vitalsource.com/books/9781119593577}
}
\author{
MaheshP Kumar, \email{maheshparamjitkumar@gmail.com}
}
