% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bitstream-uints-exp-golomb.R
\name{uint_to_exp_golomb_bits}
\alias{uint_to_exp_golomb_bits}
\alias{exp_golomb_bits_to_uint}
\title{Convert between non-negative integers and Exponential Golomb bit sequences}
\usage{
uint_to_exp_golomb_bits(x)

exp_golomb_bits_to_uint(bits, n = 1)
}
\arguments{
\item{x}{integer vector with all values >= 0}

\item{bits}{logical vector of bit values}

\item{n}{number of values to decode. Default: 1. Set to 'Inf' to decode 
all bits.  Will raise an error if there are extra bits at the end that
are not properly encoded integers}
}
\value{
logical vector of bit values, or vector of non-negative integers
}
\description{
Convert between non-negative integers and Exponential Golomb bit sequences
}
\examples{
bits <- uint_to_exp_golomb_bits(c(0, 4, 21))
bits
exp_golomb_bits_to_uint(bits, n = 3)
}
