% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/almost.equal.R
\name{almost.equal}
\alias{almost.equal}
\title{Vectorized testing for near-equality}
\usage{
almost.equal(x, y, scale = 1, ...)
}
\arguments{
\item{x, y}{R objects to be compared with each other, recycled to max length}

\item{scale}{DEFAULT scale=1 for absolute comparison for numbers. 
use scale=NULL for relative comparison (\code{all.equal} default).}

\item{\dots}{Further arguments passed to \code{\link{all.equal}}}
}
\value{
Logical vector
}
\description{
Vectorized testing for near-equality with \code{\link{all.equal}}.
Since elements are recycled, this will not work for environments.
You \emph{can} use \code{almost.equal} directly in \code{if} expressions.
}
\examples{

# General usage:
x <- c(0.4-0.1, 0.5-0.2)
x
x==0.3                    # FALSE TRUE # but mathematically, x is 0.3
all.equal(x, rep(0.3,2))  # TRUE
almost.equal(x,0.3)       # TRUE TRUE  # nice

y <- c(7777, 0.3)
   all.equal(x,y) # "Mean relative difference: 25922.33"   Not what I want
almost.equal(x,y) # FALSE TRUE                             Exactly what I want


# Absolute vs relative comparison, https://stackoverflow.com/questions/57578257

   all.equal(6.2, 6.4, tolerance=0.04) # TRUE - unexpected!
almost.equal(6.2, 6.4, tolerance=0.04) # FALSE, thanks to default scale=1
almost.equal(6.2, 6.4, tolerance=0.04, scale=NULL) # as with all.equal


# Testing vectorization
almost.equal(1:6, 3)
almost.equal(1:6, NA)
almost.equal(1:6, NULL)


# Testing the function for different data types (in order of coercion):
almost.equal(c(TRUE,FALSE,NA), c(TRUE,FALSE,NA))      # logical
almost.equal(as.factor(letters), as.factor(letters))  # factor
   all.equal(1:6, 1:6)
almost.equal(1:6, 1:6)                                # integer  numeric see above
0.4+0.4i - 0.1-0.1i == 0.3+0.3i
almost.equal(0.4+0.4i - 0.1-0.1i, 0.3+0.3i)           # complex
   all.equal(letters, tolower(LETTERS))
almost.equal(letters, tolower(LETTERS))               # character
almost.equal(Sys.Date()+1:4,Sys.Date()+1:4)           # Date
x <- Sys.time()+0:2
all.equal(x,x)
almost.equal(x,x)                                     # POSIXt
A <- list(a=1:5, b=0.5-0.2)
B <- list(a=1:5, b=0.4-0.1)
   all.equal(A,B)
almost.equal(A,B)                                     # list


}
\seealso{
\code{\link{all.equal}}
}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, Jan 2017
}
