% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetch_data.R
\name{fetch_data}
\alias{fetch_data}
\title{Fetches data from the BDDK API}
\usage{
fetch_data(
  start_year,
  start_month,
  end_year,
  end_month,
  table_no,
  currency,
  group,
  lang = "tr",
  save_excel = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{start_year}{integer: Starting year (YYYY format)}

\item{start_month}{integer: Starting month (1-12)}

\item{end_year}{integer: Ending year (YYYY format)}

\item{end_month}{integer: Ending month (1-12)}

\item{table_no}{integer: Table number (e.g., 1)}

\item{currency}{character: Currency type (e.g., "TL", "USD")}

\item{group}{integer: Group type (e.g., 10001)}

\item{lang}{character: Language selection, default 'tr'}

\item{save_excel}{logical: If TRUE, saves data to Excel. Default is FALSE.}

\item{verbose}{logical: If TRUE, print a message. Default is TRUE.}
}
\value{
data.frame: Returns data as a data.frame. Returns NULL if no data is available.
}
\description{
Fetches data from the BDDK API
}
