% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report.R
\name{prior_summary.varstan}
\alias{prior_summary.varstan}
\alias{prior_summary}
\title{Generic function for extracting information about prior distributions}
\usage{
\method{prior_summary}{varstan}(object, ...)
}
\arguments{
\item{object}{a \code{varstan} object or one of the defined current defined reports.}

\item{...}{additional values need in print methods.}
}
\value{
none. prints a string with the defined time series model report
}
\description{
The function returns a report with the users defined model for the given time series data
and all the current defined priors of the model.
}
\details{
if \code{object} is a \code{varstan} object the function will print the
information of the defined model inside of the object. If \code{object}
is one of the model classes (like \code{Sarima} or \code{garch}) then it will print the
report information as well.
}
\examples{
dat2 = garch(birth,order = c(1,1,0))
prior_summary(dat2)

}
\author{
Asael Alonzo Matamoros
}
