% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_functionals_of_model.R
\name{compute_marg_PR_nested_reg_array}
\alias{compute_marg_PR_nested_reg_array}
\title{compute positive rates for nested model with subclass mixing weights that are the same across
\code{Jcause} classes for each person (people may have different weights.)}
\usage{
compute_marg_PR_nested_reg_array(
  ThetaBS_array,
  PsiBS_array,
  pEti_mat_array,
  subwt_mat_array,
  case,
  template
)
}
\arguments{
\item{ThetaBS_array}{An array of: True positive rates for JBrS measures (rows) among K subclasses (columns)}

\item{PsiBS_array}{An array of: False positive rates; dimension same as above}

\item{pEti_mat_array}{An array of: a matrix of etiology pies for N subjects (rows) and Jcause causes (columns)
rows sum to ones.}

\item{subwt_mat_array}{An array of: a matrix of subclass weights for cases and controls. N by K. Rows sum
to ones.}

\item{case}{a N-vector of 1s (cases) and 0s (controls)}

\item{template}{a binary matrix with Jcause+1 rows (Jcause classes of cases and 1 class of controls)
and JBrS columns for the Bronze-standard measurement (say, pick one type/slice).
The ones in each row indicate the measurements that will show up more frequently in cases given the cause.}
}
\value{
An array of: a matrix of values between 0 and 1 (need not to have row sums of ones); of dimension (number of subjects, dimension of the bronze-standard
measurement slice).
}
\description{
This is an array-version of \link{compute_marg_PR_nested_reg}. This is used in \link{plot_etiology_regression}
}
