% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz_auto_visual_inference.R
\name{AUTO_VI$summary}
\alias{AUTO_VI$summary}
\title{Summary of the object}
\value{
An \code{AUTO_VI_SUMMARY} object.
}
\description{
The \code{\link[=AUTO_VI$..str..]{AUTO_VI$..str..()}} method provides a string
representation of the object. If a check is performed, the string
will contain some simple statistics of the check result. This method
does this same thing as \code{\link[=AUTO_VI$..str..]{AUTO_VI$..str..()}}, but it returns an
\code{AUTO_VI_SUMMARY} object which stores those statistics, such as sample
quantiles of the distribution of null visual signal strength, in the object.
\subsection{Usage}{

\if{html}{\out{<div class="sourceCode">}}\preformatted{AUTO_VI$summary()
}\if{html}{\out{</div>}}
}
}
\examples{
keras_model <- try(get_keras_model("vss_phn_32"))
if (!inherits(keras_model, "try-error")) {
  myvi <- auto_vi(lm(dist ~ speed, data = cars), keras_model)

  myvi$check()
  myvi_summary <- myvi$summary()
  print(myvi_summary)
  names(myvi_summary)
}
}
