% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz_auto_visual_inference.R
\name{AUTO_VI$plot_lineup}
\alias{AUTO_VI$plot_lineup}
\title{Draw a lineup of standard residual plots}
\arguments{
\item{lineup_size}{Numeric. Number of plots in a lineup.}

\item{data}{Data frame. A data frame containing variables \code{.resid} and
\code{.fitted}. See also \code{\link[=AUTO_VI$get_fitted_and_resid]{AUTO_VI$get_fitted_and_resid()}}.}

\item{null_method}{Function. A function that takes a fitted model as input,
and outputs a data frame containing variables \code{.resid} and
\code{.fitted}. See also \code{\link[=AUTO_VI$null_method]{AUTO_VI$null_method()}}.}

\item{theme}{\code{ggtheme}. A \code{ggplot} theme object.
See also \code{\link[ggplot2:ggtheme]{ggplot2::theme_light()}}.}

\item{alpha}{Numeric. Alpha of dot. Value between 0 and 1.}

\item{size}{Numeric. Size of dot. Value between 0 and 1.}

\item{stroke}{Numeric. Stroke of dot. Value between 0 and 1.}

\item{remove_axis}{Boolean. Whether or not to remove the axis.}

\item{remove_legend}{Boolean. Whether or not to remove the legend.}

\item{remove_grid_line}{Boolean. Whether or not to remove the grid lines.}

\item{add_zero_line}{Boolean. Whether or not to add a zero horizontal line.}

\item{remove_facet_label}{Boolean. Whether or not to remove facet labels.}

\item{display_answer}{Boolean. Whether or not to display the answer in title.}
}
\value{
A \code{ggplot}.
}
\description{
This function draws a lineup of standard residual plots
consisting of a true residual plot and several null residual plots.
\subsection{Usage}{

\if{html}{\out{<div class="sourceCode">}}\preformatted{AUTO_VI$plot_lineup(
  lineup_size = 20L,
  data = self$get_fitted_and_resid(),
  null_method = self$null_method,
  theme = ggplot2::theme_light(),
  alpha = 1,
  size = 0.5,
  stroke = 0.5,
  remove_axis = TRUE,
  remove_legend = TRUE,
  remove_grid_line = TRUE,
  add_zero_line = TRUE,
  remove_facet_label = FALSE,
  display_answer = TRUE
)
}\if{html}{\out{</div>}}
}
}
\examples{

my_vi <- auto_vi(fitted_model = lm(speed ~ dist, data = cars))
my_vi$plot_lineup()
}
