% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz_auto_visual_inference.R
\name{AUTO_VI$boot_vss}
\alias{AUTO_VI$boot_vss}
\title{Predict visual signal strength for bootstrapped residual plots}
\arguments{
\item{draws}{Integer. Number of simulation draws.}

\item{fitted_model}{Model. A model object, e.g. \code{lm}.}

\item{keras_model}{Keras model. A trained computer vision model.}

\item{data}{Data frame. The data used to fit the model.
See also \code{\link[=AUTO_VI$get_data]{AUTO_VI$get_data()}}.}

\item{node_index}{Integer. An index indicating which node of the output layer
contains the visual signal strength. This is particularly useful
when the keras model has more than one output nodes.}

\item{keep_boot_data}{Boolean. Whether to keep the bootstrapped data.}

\item{keep_boot_plot}{Boolean. Whether to keep the bootstrapped plots.}

\item{extract_feature_from_layer}{Character/Integer. A layer name or an
integer layer index for extracting features from a layer.}
}
\value{
A tibble.
}
\description{
This function bootstrap the data and refits the model by using
\code{\link[=AUTO_VI$boot_method]{AUTO_VI$boot_method()}}, then predicts the visual signal strength
of the bootstrapped residual plots.
\subsection{Usage}{

\if{html}{\out{<div class="sourceCode">}}\preformatted{AUTO_VI$boot_vss(
  draws = 100L,
  fitted_model = self$fitted_model,
  keras_model = self$keras_model,
  data = self$get_data(),
  node_index = 1L,
  keep_boot_data = FALSE,
  keep_boot_plot = FALSE,
  extract_feature_from_layer = NULL
)
}\if{html}{\out{</div>}}
}
}
\examples{
keras_model <- try(get_keras_model("vss_phn_32"))
if (!inherits(keras_model, "try-error")) {
  myvi <- auto_vi(lm(dist ~ speed, data = cars), keras_model)

  myvi$boot_vss()
}
}
