% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz_auto_visual_inference.R
\name{AUTO_VI$boot_method}
\alias{AUTO_VI$boot_method}
\title{Get bootstrapped residuals from a fitted model}
\arguments{
\item{fitted_model}{\code{lm}. A linear model object.}

\item{data}{Data frame. The data used to fit the model.
See also \code{\link[=AUTO_VI$get_data]{AUTO_VI$get_data()}}.}
}
\value{
A tibble with two columns \code{.fitted} and \code{.resid}.
}
\description{
This default method gets bootstrapped residuals from a
fitted linear model by sampling the observations with replacement
then refit the model. User needs to override this method if
a different bootstrapping scheme is needed.
\subsection{Usage}{

\if{html}{\out{<div class="sourceCode">}}\preformatted{AUTO_VI$boot_method(
  fitted_model = self$fitted_model,
  data = self$get_data()
)
}\if{html}{\out{</div>}}
}
}
\examples{

my_vi <- auto_vi(fitted_model = lm(speed ~ dist, data = cars))
null_resid <- my_vi$boot_method()
my_vi$plot_resid(null_resid)
}
