% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/construct_blueprint.R
\name{construct_blueprint}
\alias{construct_blueprint}
\title{Build a Blueprint Data Frame for the Focal FC Scale}
\usage{
construct_blueprint(N_blocks, block_size, traits, signs)
}
\arguments{
\item{N_blocks}{Number of total FC blocks}

\item{block_size}{Desired block size for the FC scale}

\item{traits, signs}{Optional vectors. If given, specifies which traits and signs
each item in the FC scale should have. \code{traits} is a string vector,
while \code{signs} is a numeric vector (1 for positive items and -1 for negative items)}
}
\value{
A data frame, containing the block membership, trait and keying information of
all the items.
}
\description{
This function takes in specifications of block size, number of blocks,
as well as trait and keying of each item in these blocks, and returns a data frame
incorporating these information and ready to be further used for constructing FC
blocks by other functions like \code{build_scale_with_blueprint()}.
}
\details{
A "blueprint" of the forced-choice scale is essentially a data frame
where each row represents one item in the forced-choice scale, and columns specify
which block the item belongs to, the trait that the item measures, and the keying of
that item.

Note that these are only the basic item information typically needed when matching items
into FC blocks; Users can further add other columns to the blueprint if they want to match
based on more criteria.
}
\examples{
example_blueprint <- construct_blueprint(N_blocks = 5, block_size = 3, 
                                         traits = sample(c("Openness", 
                                                           "Conscientiousness", 
                                                           "Extraversion", 
                                                           "Agreeableness", 
                                                           "Neuroticism"), 15, replace = TRUE),
                                         signs = sample(c(-1, 1), 15, replace = TRUE))

}
\author{
Mengtong Li
}
